#ifndef _TIMER_H_
#define _TIMER_H_

#include "ht32f520xx_01.h"

#define	BFTM_MIEN	(1UL << 0)
#define	BFTM_OSM		(1UL << 1)
#define	BFTM_CEN		(1UL << 2)
#define	BFTM_MIF		(1UL << 0)

#define	TICK_RATE_MS(TT)	(TT)

typedef struct 
{
   u32 value;
	union 
	{
		u8	Flag;
		struct {
   		u8 t1ms : 1;
   		u8 t10ms : 1;
   		const u8 : 6;
		}bits;
	};
} timer_operate_t;

extern timer_operate_t timer_operate;
extern timer_operate_t UART_timer_operate;

void BFTM0_configure(void);
void BFTM0_IRQHandler(void);

u32  RESET_TICK_COUNT(void);
u32  GET_TICK_COUNT(void);
void delay_ms(unsigned long n);
void delay_10us(unsigned long n);

#endif /* _TIMER_H_ */
